using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgIssuedReturnedReportCriteria
	/// </summary>
	public class DlgIssuedReturnedReportCriteria : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private bool _isLoading;
		private BOL.IssueReturnReport _report;

		#region form controls

		private System.Windows.Forms.GroupBox grpReportCompilation;
		private System.Windows.Forms.RadioButton rdoScheduleJob;
		private System.Windows.Forms.RadioButton rdoCreateNow;
		private System.Windows.Forms.GroupBox grpScheduleJob;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPrinterName;
		private System.Windows.Forms.Label lblPrinterName;
		private System.Windows.Forms.Label lblPrintDate;
		private System.Windows.Forms.DateTimePicker dtpPrintDate;
		private System.Windows.Forms.GroupBox grpDateRange;
		private System.Windows.Forms.Label lblEndDate;
		private System.Windows.Forms.Label lblStartDate;
		private System.Windows.Forms.DateTimePicker dtpStartDate;
		private System.Windows.Forms.DateTimePicker dtpEndDate;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.GroupBox grpReportSortOrder;
		private System.Windows.Forms.RadioButton rdoSortByDate;
		private System.Windows.Forms.RadioButton rdoSortByPatient;
		private System.ComponentModel.IContainer components = null;

		#endregion


		#region constructors

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgIssuedReturnedReportCriteria()
		{
			InitializeComponent();

			_report = new BOL.IssueReturnReport();
			_report.Valid += new System.EventHandler(this.CheckValid);
			_report.Invalid += new System.EventHandler(this.CheckValid);
			_report.IsDirtyChanged += new System.EventHandler(this.CheckValid);
			_report.SetInitialBrokenRules(this.Name);

			SetComponentProperties();
		}

		#endregion


		#region property

		/// <summary>
		/// Gets IssueReturn report object
		/// </summary>
		public BOL.IssueReturnReport IssueReturnReport
		{
			get
			{
				return _report;
			}
		}

		#endregion


		#region methods

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgIssuedReturnedReportCriteria));
			this.grpReportCompilation = new System.Windows.Forms.GroupBox();
			this.rdoScheduleJob = new System.Windows.Forms.RadioButton();
			this.rdoCreateNow = new System.Windows.Forms.RadioButton();
			this.grpScheduleJob = new System.Windows.Forms.GroupBox();
			this.cmbPrinterName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblPrinterName = new System.Windows.Forms.Label();
			this.lblPrintDate = new System.Windows.Forms.Label();
			this.dtpPrintDate = new System.Windows.Forms.DateTimePicker();
			this.grpReportSortOrder = new System.Windows.Forms.GroupBox();
			this.rdoSortByPatient = new System.Windows.Forms.RadioButton();
			this.rdoSortByDate = new System.Windows.Forms.RadioButton();
			this.grpDateRange = new System.Windows.Forms.GroupBox();
			this.lblEndDate = new System.Windows.Forms.Label();
			this.lblStartDate = new System.Windows.Forms.Label();
			this.dtpStartDate = new System.Windows.Forms.DateTimePicker();
			this.dtpEndDate = new System.Windows.Forms.DateTimePicker();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpReportCompilation.SuspendLayout();
			this.grpScheduleJob.SuspendLayout();
			this.grpReportSortOrder.SuspendLayout();
			this.grpDateRange.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(392, 30);
			this.vbecsLogo1.TabIndex = 5;
			this.vbecsLogo1.Title = "Issued/Returned Units Report";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 293);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 7;
			// 
			// grpReportCompilation
			// 
			this.grpReportCompilation.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReportCompilation.Controls.Add(this.rdoScheduleJob);
			this.grpReportCompilation.Controls.Add(this.rdoCreateNow);
			this.grpReportCompilation.Controls.Add(this.grpScheduleJob);
			this.grpReportCompilation.Location = new System.Drawing.Point(60, 148);
			this.grpReportCompilation.Name = "grpReportCompilation";
			this.grpReportCompilation.Size = new System.Drawing.Size(326, 124);
			this.grpReportCompilation.TabIndex = 2;
			this.grpReportCompilation.TabStop = false;
			this.grpReportCompilation.Text = "Report Compilation*";
			// 
			// rdoScheduleJob
			// 
			this.rdoScheduleJob.Location = new System.Drawing.Point(16, 40);
			this.rdoScheduleJob.Name = "rdoScheduleJob";
			this.rdoScheduleJob.Size = new System.Drawing.Size(120, 16);
			this.rdoScheduleJob.TabIndex = 1;
			this.rdoScheduleJob.Text = "&Schedule Print Job";
			this.rdoScheduleJob.CheckedChanged += new System.EventHandler(this.ReportCompilationChanged);
			// 
			// rdoCreateNow
			// 
			this.rdoCreateNow.Checked = true;
			this.rdoCreateNow.Location = new System.Drawing.Point(16, 20);
			this.rdoCreateNow.Name = "rdoCreateNow";
			this.rdoCreateNow.Size = new System.Drawing.Size(124, 16);
			this.rdoCreateNow.TabIndex = 0;
			this.rdoCreateNow.TabStop = true;
			this.rdoCreateNow.Text = "Create Report &Now";
			this.rdoCreateNow.CheckedChanged += new System.EventHandler(this.ReportCompilationChanged);
			// 
			// grpScheduleJob
			// 
			this.grpScheduleJob.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpScheduleJob.Controls.Add(this.cmbPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrintDate);
			this.grpScheduleJob.Controls.Add(this.dtpPrintDate);
			this.grpScheduleJob.Enabled = false;
			this.grpScheduleJob.Location = new System.Drawing.Point(8, 40);
			this.grpScheduleJob.Name = "grpScheduleJob";
			this.grpScheduleJob.Size = new System.Drawing.Size(310, 76);
			this.grpScheduleJob.TabIndex = 2;
			this.grpScheduleJob.TabStop = false;
			// 
			// cmbPrinterName
			// 
			this.cmbPrinterName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbPrinterName.Interval = 500;
			this.cmbPrinterName.Location = new System.Drawing.Point(96, 44);
			this.cmbPrinterName.Name = "cmbPrinterName";
			this.cmbPrinterName.Size = new System.Drawing.Size(206, 22);
			this.cmbPrinterName.TabIndex = 3;
			this.cmbPrinterName.SelectedIndexChanged += new System.EventHandler(this.cmbPrinterName_SelectedIndexChanged);
			// 
			// lblPrinterName
			// 
			this.lblPrinterName.Location = new System.Drawing.Point(24, 44);
			this.lblPrinterName.Name = "lblPrinterName";
			this.lblPrinterName.Size = new System.Drawing.Size(76, 20);
			this.lblPrinterName.TabIndex = 2;
			this.lblPrinterName.Text = "Printer Name*";
			this.lblPrinterName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPrintDate
			// 
			this.lblPrintDate.Location = new System.Drawing.Point(24, 20);
			this.lblPrintDate.Name = "lblPrintDate";
			this.lblPrintDate.Size = new System.Drawing.Size(72, 20);
			this.lblPrintDate.TabIndex = 0;
			this.lblPrintDate.Text = "Print Date*";
			this.lblPrintDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpPrintDate
			// 
			this.dtpPrintDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpPrintDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpPrintDate.CustomFormat = "MM/dd/yyyy hh:mm";
			this.dtpPrintDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpPrintDate.Location = new System.Drawing.Point(96, 20);
			this.dtpPrintDate.Name = "dtpPrintDate";
			this.dtpPrintDate.Size = new System.Drawing.Size(206, 20);
			this.dtpPrintDate.TabIndex = 1;
			this.dtpPrintDate.Value = new System.DateTime(2003, 6, 20, 15, 24, 4, 467);
			this.dtpPrintDate.ValueChanged += new System.EventHandler(this.dtpPrintDate_ValueChanged);
			// 
			// grpReportSortOrder
			// 
			this.grpReportSortOrder.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReportSortOrder.Controls.Add(this.rdoSortByPatient);
			this.grpReportSortOrder.Controls.Add(this.rdoSortByDate);
			this.grpReportSortOrder.Location = new System.Drawing.Point(60, 84);
			this.grpReportSortOrder.Name = "grpReportSortOrder";
			this.grpReportSortOrder.Size = new System.Drawing.Size(326, 60);
			this.grpReportSortOrder.TabIndex = 1;
			this.grpReportSortOrder.TabStop = false;
			this.grpReportSortOrder.Text = "Report Sort Order*";
			// 
			// rdoSortByPatient
			// 
			this.rdoSortByPatient.Location = new System.Drawing.Point(12, 36);
			this.rdoSortByPatient.Name = "rdoSortByPatient";
			this.rdoSortByPatient.Size = new System.Drawing.Size(160, 20);
			this.rdoSortByPatient.TabIndex = 1;
			this.rdoSortByPatient.Text = "&Patient Name";
			this.rdoSortByPatient.CheckedChanged += new System.EventHandler(this.ReportSortOrderChanged);
			// 
			// rdoSortByDate
			// 
			this.rdoSortByDate.Checked = true;
			this.rdoSortByDate.Location = new System.Drawing.Point(12, 16);
			this.rdoSortByDate.Name = "rdoSortByDate";
			this.rdoSortByDate.Size = new System.Drawing.Size(156, 20);
			this.rdoSortByDate.TabIndex = 0;
			this.rdoSortByDate.TabStop = true;
			this.rdoSortByDate.Text = "&Issue/Return Date";
			this.rdoSortByDate.CheckedChanged += new System.EventHandler(this.ReportSortOrderChanged);
			// 
			// grpDateRange
			// 
			this.grpDateRange.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDateRange.Controls.Add(this.lblEndDate);
			this.grpDateRange.Controls.Add(this.lblStartDate);
			this.grpDateRange.Controls.Add(this.dtpStartDate);
			this.grpDateRange.Controls.Add(this.dtpEndDate);
			this.grpDateRange.Location = new System.Drawing.Point(60, 32);
			this.grpDateRange.Name = "grpDateRange";
			this.grpDateRange.Size = new System.Drawing.Size(326, 48);
			this.grpDateRange.TabIndex = 0;
			this.grpDateRange.TabStop = false;
			this.grpDateRange.Text = "Report Date Range";
			// 
			// lblEndDate
			// 
			this.lblEndDate.Location = new System.Drawing.Point(168, 20);
			this.lblEndDate.Name = "lblEndDate";
			this.lblEndDate.Size = new System.Drawing.Size(56, 20);
			this.lblEndDate.TabIndex = 2;
			this.lblEndDate.Text = "End Date*";
			this.lblEndDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblStartDate
			// 
			this.lblStartDate.Location = new System.Drawing.Point(8, 20);
			this.lblStartDate.Name = "lblStartDate";
			this.lblStartDate.Size = new System.Drawing.Size(60, 20);
			this.lblStartDate.TabIndex = 0;
			this.lblStartDate.Text = "Start Date*";
			this.lblStartDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpStartDate
			// 
			this.dtpStartDate.CalendarFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpStartDate.CustomFormat = "MM/dd/yyyy";
			this.dtpStartDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpStartDate.Location = new System.Drawing.Point(68, 20);
			this.dtpStartDate.Name = "dtpStartDate";
			this.dtpStartDate.Size = new System.Drawing.Size(84, 20);
			this.dtpStartDate.TabIndex = 1;
			this.dtpStartDate.Value = new System.DateTime(2004, 4, 7, 0, 0, 0, 0);
			this.dtpStartDate.ValueChanged += new System.EventHandler(this.dtpStartDate_ValueChanged);
			// 
			// dtpEndDate
			// 
			this.dtpEndDate.CalendarFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpEndDate.CustomFormat = "MM/dd/yyyy";
			this.dtpEndDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpEndDate.Location = new System.Drawing.Point(224, 20);
			this.dtpEndDate.Name = "dtpEndDate";
			this.dtpEndDate.Size = new System.Drawing.Size(84, 20);
			this.dtpEndDate.TabIndex = 3;
			this.dtpEndDate.Value = new System.DateTime(2004, 4, 7, 0, 0, 0, 0);
			this.dtpEndDate.ValueChanged += new System.EventHandler(this.dtpEndDate_ValueChanged);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(234, 277);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 3;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnCancel.Location = new System.Drawing.Point(314, 277);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 4;
			this.btnCancel.Text = "&Cancel";
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 240);
			this.grpImage.TabIndex = 6;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 1;
			this.pictureBox1.TabStop = false;
			// 
			// DlgIssuedReturnedReportCriteria
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(392, 309);
			this.Controls.Add(this.grpReportCompilation);
			this.Controls.Add(this.grpReportSortOrder);
			this.Controls.Add(this.grpDateRange);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.grpImage);
			this.hlphelpChm.SetHelpKeyword(this, "Issued_Returned_Unit_Report.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(400, 336);
			this.Name = "DlgIssuedReturnedReportCriteria";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Issued/Returned Units Report";
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.grpDateRange, 0);
			this.Controls.SetChildIndex(this.grpReportSortOrder, 0);
			this.Controls.SetChildIndex(this.grpReportCompilation, 0);
			this.grpReportCompilation.ResumeLayout(false);
			this.grpScheduleJob.ResumeLayout(false);
			this.grpReportSortOrder.ResumeLayout(false);
			this.grpDateRange.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void SetComponentProperties()
		{
			_isLoading = true;
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";

			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC076.DlgIssuedReturnedReportCriteria());
			//
			this.btnOK.EnabledButton = true;
			this.btnOK.Text = "&OK";
			//
			this.dtpStartDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpEndDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpPrintDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

			// BR_77.01
			this.dtpEndDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime(LogonUser.LogonUserDivisionCode).AddDays(-1);
			this.dtpEndDate.MinDate = this.dtpStartDate.Value;

			// BR_77.01
			this.dtpStartDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime(LogonUser.LogonUserDivisionCode).AddDays(-1);
			this.dtpStartDate.MaxDate = this.dtpEndDate.Value;

			this.dtpPrintDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime(LogonUser.LogonUserDivisionCode);
			this.dtpPrintDate.MinDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime(LogonUser.LogonUserDivisionCode);

			// load printer combobox
			foreach (string printerName in BOL.DivisionAlerts.GetPrinters())
			{
				this.cmbPrinterName.Items.Add(printerName);
			}

			_isLoading = false;
		}

		private void CheckValid(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = (_report.IsValid);
		
			if (_report.IsValid)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
			}
			else
			{
				this.btnOK.SetToolTip(_report.GetBrokenRulesMessage(this.Name));
			}
		}

		#endregion


		#region events

		#region datetimepickers
		
		private void dtpStartDate_ValueChanged(object sender, System.EventArgs e)
		{
			if (!_isLoading)
			{
				this.dtpEndDate.MinDate = this.dtpStartDate.Value;
				_report.StartDate = dtpStartDate.Value;	
			}
		}

		private void dtpEndDate_ValueChanged(object sender, System.EventArgs e)
		{
			if (!_isLoading)
			{
				this.dtpStartDate.MaxDate = this.dtpEndDate.Value;
				_report.EndDate = dtpEndDate.Value;
			}
		}

		private void dtpPrintDate_ValueChanged(object sender, System.EventArgs e)
		{
			_report.PrintDate = this.dtpPrintDate.Value;
		}

		#endregion


		#region radio buttons

		/// <summary>
		/// BR_76.03 - Order may be sorted by date or patient
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ReportSortOrderChanged(object sender, System.EventArgs e)
		{
			if (this.rdoSortByDate.Checked)
			{
				_report.SortByDate = true;
			}
			else
			{
				_report.SortByDate = false;
			}
		
		}

		private void ReportCompilationChanged(object sender, System.EventArgs e)
		{
			if (this.rdoScheduleJob.Checked)
			{
				_report.IsScheduled = true;
				this.grpScheduleJob.Enabled = true;
				if (_report.PrintDate == DateTime.MinValue)
				{
					this.dtpPrintDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
				}
			}
			else
			{
				_report.IsScheduled = false;
				this.grpScheduleJob.Enabled = false;
			}
		}

		private void cmbPrinterName_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(cmbPrinterName.SelectedItem!=null)
			{
				string printer=this.cmbPrinterName.Text;
				for(int i=0; i<this.cmbPrinterName.Items.Count; i++)
				{
					if(printer==this.cmbPrinterName.Items[i].ToString())
					{
						this._report.PrinterName = cmbPrinterName.SelectedItem.ToString();
					}
				}
			}		
			else
			{
				this._report.PrinterName=String.Empty;
			}
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;

			if (_report.IsScheduled)
			{
				if (!_report.IsScheduledReportGreaterThanThirtyDays ||
					(_report.IsScheduledReportGreaterThanThirtyDays && 
					DialogResult.Yes == GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.ScheduledReportGreaterThanThirtyDays())))
				{
					_report.Schedule();
				}
			}
			else
			{
				int count = _report.RecordCount;
				//
				if(count==0)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC049.NoInfoReturned());
				}
				else if((count/20)>=50) //assuming 20 records per page
				{
					DialogResult _result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC049.PageCountAlert());
					if( _result == DialogResult.Yes )
					{
						this.DialogResult = DialogResult.OK;
					}
				}
				else
				{
					this.DialogResult = DialogResult.OK;
				}
			}
			this.Close();
		}

		#endregion

		#endregion		
	}
}

